### ###Overview of Port Security

- **Purpose**
    - Restricts a switch port to a specific set or number of MAC addresses.
    - Protects against MAC spoofing and MAC flooding (Layer 2 attacks).
- **Configuration Options**
    - MAC addresses can be learned dynamically or configured statically.
    - Only frames from secure (allowed) MAC addresses are accepted on the port.

---

### How Port Security Works

- **Operation**
    - Limits the maximum number of MAC addresses allowed on a port.
    - Allows only specified MAC addresses to access the port.
    - If a MAC address is not in the secure list:
        - If dynamic learning is enabled and there is room, it is added to the list.
        - If not, a violation occurs and the configured action is triggered.

---

### Violation Modes

- **Protect**
    - Drops offending frames silently.
    - Does not increase security violation count.
- **Restrict**
    - Drops offending frames.
    - Increments security violation count.
    - Generates SNMP trap or syslog message.
- **Shutdown (Default)**
    - Places the interface in error-disabled state.
    - Port becomes inactive; requires admin intervention.
    - Increments security violation count.
    - Generates SNMP trap or syslog message.

---

### Layer 2 Attacks Mitigated by Port Security

#### MAC Spoofing

- **Description**
    - Attacker uses the MAC address of a legitimate host to receive traffic intended for that host.
    - Switch updates its CAM table to point to the attacker, causing misdelivery of frames.
- **Mitigation**
    - Port security ensures only authorized MAC addresses are accepted.

#### MAC Flooding (CAM Table Overflow)

- **Description**
    - Attacker floods the switch with fake MAC addresses, filling up the CAM table.
    - Switches to flooding mode (like a hub), exposing traffic to all ports in the VLAN.
- **Mitigation**
    - Limit the number of MAC addresses per port.
    - Frames from unauthorized MAC addresses trigger violation actions.

---

### Port Security Configuration Example

**Typical Scenario: Voice Port with PC and IP Phone**


```plaintext
Switch(config)# interface FastEthernet 0/1
Switch(config-if)# switchport mode access
Switch(config-if)# switchport port-security
Switch(config-if)# switchport port-security maximum 2
Switch(config-if)# switchport port-security violation restrict
Switch(config-if)# switchport port-security mac-address sticky
Switch(config-if)# switchport port-security aging time 120
```

- **Explanation:**
    - Allows two MAC addresses (for PC and IP phone).
    - Uses sticky learning for dynamic MAC address assignment.
    - Restrict mode keeps port active but denies offending frames, logs violations.
    - Sets MAC address aging time to 2 hours.

---

### Port Security Verification Example

- **Command:**
    - `show port-security interface FastEthernet 0/1`
- **Sample Output Highlights:**
    - Port Security: Enabled
    - Port Status: Secure-down (port shut down due to violation)
    - Violation Mode: Shutdown
    - Maximum MAC Addresses: 2
    - Security Violation Count: 1
    - Last Source Address: (offending MAC address)

---

### Key Points and Best Practices

- **Statically configuring MAC addresses is secure but not scalable.**
- **Dynamic learning with a limit is preferable for scalability.**
- **Always configure violation actions appropriate to the port's function and criticality.**
- **Regularly verify port security status and violation counts.**
- **Port security is essential for mitigating common Layer 2 attacks in enterprise networks.Overview of Port Security
